<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EndPoint extends Model 
{

    protected $table = 'endpoints';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('type', 'code');

    public function Messages()
    {
        return $this->hasMany('Message');
    }

    public function Customer()
    {
        return $this->belongsTo('Customer');
    }

}